import { FormInput } from "@/Components/ui/FormInput";
import { NormalSelect } from "@/Components/ui/NormalSelect";
import AdminLayout from "@/Layouts/AdminLayout";
import { Link, useForm } from "@inertiajs/react";

export default function Edit({ user }) {
    const { data, setData, put, processing, errors } = useForm({
        name: user.name,
        email: user.email,
        user_type: user.user_type,
        status: user.status,
        password: "",
        password_confirmation: "",
    });

    const handleSubmit = (e) => {
        e.preventDefault();
        put(route("admin.users.update", user.id));
    };

    return (
        <AdminLayout>
            <div className="max-w-2xl mx-auto mt-10">
                <div className="bg-gradient-to-r from-orange-200 to-cyan-200 dark:bg-none dark:bg-gray-800 rounded-lg shadow-lg">
                    <div className="px-6 py-4 border-b dark:border-gray-700 bg-gradient-to-r from-blue-900 to-cyan-500 rounded-t-lg">
                        <h1 className="text-md lg:text-xl font-bold text-blue-100 dark:text-blue-400">
                            Update User
                        </h1>
                    </div>

                    <form onSubmit={handleSubmit} className="p-6 space-y-6">
                        <FormInput
                            id="name"
                            name="name"
                            label="Full Name"
                            value={data.name}
                            setData={setData}
                            error={errors.name}
                            placeholder="Enter Fullname"
                            required
                        />

                        <FormInput
                            id="email"
                            type="email"
                            name="email"
                            label="Email"
                            value={data.email}
                            setData={setData}
                            error={errors.email}
                            placeholder="Enter Email"
                            required
                        />

                        <FormInput
                            id="password"
                            type="password"
                            name="password"
                            label="Password (Optional)"
                            value={data.password}
                            setData={setData}
                            error={errors.password}
                            placeholder="Enter Password"
                        />

                        <FormInput
                            id="password_confirmation"
                            type="password"
                            name="password_confirmation"
                            label="Confirm Password (Optional)"
                            value={data.password_confirmation}
                            setData={setData}
                            error={errors.password_confirmation}
                            placeholder="Confirm Password"
                        />

                        <NormalSelect
                            id="user_type"
                            name="user_type"
                            label="User Type"
                            value={data.user_type}
                            setData={setData}
                            options={[
                                { id: 1, value: "client", name: "Client" },
                                { id: 2, value: "admin", name: "Admin" },
                                { id: 3, value: "writer", name: "Writer" },
                            ]}
                            error={errors.user_type}
                            placeholder="Select User Type"
                        />

                        <NormalSelect
                            id="status"
                            name="status"
                            label="Status"
                            value={data.status}
                            setData={setData}
                            options={[
                                { id: 1, value: "active", name: "Active" },
                                { id: 2, value: "inactive", name: "Inactive" },
                            ]}
                            error={errors.status}
                            placeholder="Select Status"
                        />

                        <div className="flex justify-end gap-3">
                            <Link
                                href={route("admin.users.index")}
                                className="px-4 py-2 bg-gray-500 text-white rounded-md hover:bg-gray-600"
                            >
                                Cancel
                            </Link>
                            <button
                                type="submit"
                                disabled={processing}
                                className="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 disabled:opacity-50"
                            >
                                Update
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </AdminLayout>
    );
}
