import GuestLayout from "@/Layouts/GuestLayout";
import { Head, Link } from "@inertiajs/react";

export default function Inactive({ message }) {
    return (
        <GuestLayout>
            <Head title="Account Deactivated" />

            <div className="min-h-screen flex flex-col items-center justify-center bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-gray-100 p-4">
                <div className="max-w-md w-full space-y-6 text-center">
                    <h1 className="text-2xl font-bold">Account Deactivated</h1>
                    <p className="text-sm">
                        {message ||
                            "Your account has been deactivated. Please contact the admin for assistance."}
                    </p>
                    <div className="flex justify-center space-x-4 mt-4">
                        <Link
                            href="/"
                            className="text-blue-500 hover:underline dark:text-blue-400"
                        >
                            Home
                        </Link>
                        <Link
                            href="/login"
                            className="text-blue-500 hover:underline dark:text-blue-400"
                        >
                            Login
                        </Link>
                    </div>
                </div>
            </div>
        </GuestLayout>
    );
}
