import InputError from "@/Components/InputError";
import InputLabel from "@/Components/InputLabel";
import PrimaryButton from "@/Components/PrimaryButton";
import TextInput from "@/Components/TextInput";
import GuestLayout from "@/Layouts/GuestLayout";
import { Head, Link, useForm } from "@inertiajs/react";
import { User, Mail, Lock, Eye, EyeOff, Shield, Users, Star, CheckCircle } from "lucide-react";
import { useState } from "react";

export default function Register() {
    const { data, setData, post, processing, errors, reset } = useForm({
        name: "",
        email: "",
        password: "",
        password_confirmation: "",
    });

    const [showPassword, setShowPassword] = useState(false);
    const [showConfirmPassword, setShowConfirmPassword] = useState(false);

    const submit = (e) => {
        e.preventDefault();

        post(route("register"), {
            onFinish: () => reset("password", "password_confirmation"),
        });
    };

    return (
        <GuestLayout>
            <Head title="Register" />

            <div className="w-full overflow-hidden bg-gradient-to-r from-blue-100 to-cyan-100 dark:bg-none border border-gray-300 dark:border-gray-600 px-8 py-8 shadow-xl sm:rounded-xl transition-colors duration-200">
                {/* Header */}
                <div className="text-center mb-8">
                    <div className="mx-auto w-12 h-12 bg-green-100 dark:bg-green-900/30 rounded-full flex items-center justify-center mb-4">
                        <User className="w-6 h-6 text-green-600 dark:text-green-400" />
                    </div>
                    <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-2">
                        Create your account
                    </h2>
                    <p className="text-gray-600 dark:text-gray-400">
                        Join thousands of satisfied students
                    </p>
                </div>

                {/* Benefits */}
                <div className="mb-6 p-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-700 rounded-lg">
                    <div className="space-y-2">
                        <div className="flex items-center">
                            <CheckCircle className="w-4 h-4 text-green-600 dark:text-green-400 mr-2" />
                            <span className="text-sm text-green-700 dark:text-green-300">
                                Get 20% off your first order
                            </span>
                        </div>
                        <div className="flex items-center">
                            <CheckCircle className="w-4 h-4 text-green-600 dark:text-green-400 mr-2" />
                            <span className="text-sm text-green-700 dark:text-green-300">
                                Free revisions and 24/7 support
                            </span>
                        </div>
                        <div className="flex items-center">
                            <CheckCircle className="w-4 h-4 text-green-600 dark:text-green-400 mr-2" />
                            <span className="text-sm text-green-700 dark:text-green-300">
                                Secure payment and privacy protection
                            </span>
                        </div>
                    </div>
                </div>

                {/* Social Proof */}
                <div className="mb-6 p-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg">
                    <div className="flex items-center justify-between">
                        <div className="flex items-center">
                            <Users className="w-4 h-4 text-blue-600 dark:text-blue-400 mr-2" />
                            <span className="text-sm text-blue-700 dark:text-blue-300">
                                Join 10,000+ satisfied students
                            </span>
                        </div>
                        <div className="flex items-center">
                            {[...Array(5)].map((_, i) => (
                                <Star key={i} className="w-4 h-4 text-yellow-400 fill-current" />
                            ))}
                            <span className="text-sm text-blue-700 dark:text-blue-300 ml-1">
                                4.9/5
                            </span>
                        </div>
                    </div>
                </div>

                <form onSubmit={submit} className="space-y-6">
                    {/* Name Field */}
                    <div>
                        <InputLabel htmlFor="name" value="Full Name" className="text-gray-700 dark:text-gray-300" />
                        <div className="relative mt-1">
                            <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <User className="h-5 w-5 text-gray-400" />
                            </div>
                            <TextInput
                                id="name"
                                name="name"
                                value={data.name}
                                className="pl-10 w-full"
                                autoComplete="name"
                                isFocused={true}
                                onChange={(e) => setData("name", e.target.value)}
                                placeholder="Enter your full name"
                                required
                            />
                        </div>
                        <InputError message={errors.name} className="mt-2" />
                    </div>

                    {/* Email Field */}
                    <div>
                        <InputLabel htmlFor="email" value="Email" className="text-gray-700 dark:text-gray-300" />
                        <div className="relative mt-1">
                            <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <Mail className="h-5 w-5 text-gray-400" />
                            </div>
                            <TextInput
                                id="email"
                                type="email"
                                name="email"
                                value={data.email}
                                className="pl-10 w-full"
                                autoComplete="username"
                                onChange={(e) => setData("email", e.target.value)}
                                placeholder="Enter your email address"
                                required
                            />
                        </div>
                        <InputError message={errors.email} className="mt-2" />
                    </div>

                    {/* Password Field */}
                    <div>
                        <InputLabel htmlFor="password" value="Password" className="text-gray-700 dark:text-gray-300" />
                        <div className="relative mt-1">
                            <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <Lock className="h-5 w-5 text-gray-400" />
                            </div>
                            <TextInput
                                id="password"
                                type={showPassword ? "text" : "password"}
                                name="password"
                                value={data.password}
                                className="pl-10 pr-10 w-full"
                                autoComplete="new-password"
                                onChange={(e) => setData("password", e.target.value)}
                                placeholder="Create a strong password"
                                required
                            />
                            <button
                                type="button"
                                className="absolute inset-y-0 right-0 pr-3 flex items-center"
                                onClick={() => setShowPassword(!showPassword)}
                            >
                                {showPassword ? (
                                    <EyeOff className="h-5 w-5 text-gray-400 hover:text-gray-600" />
                                ) : (
                                    <Eye className="h-5 w-5 text-gray-400 hover:text-gray-600" />
                                )}
                            </button>
                        </div>
                        <InputError message={errors.password} className="mt-2" />
                    </div>

                    {/* Confirm Password Field */}
                    <div>
                        <InputLabel htmlFor="password_confirmation" value="Confirm Password" className="text-gray-700 dark:text-gray-300" />
                        <div className="relative mt-1">
                            <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <Lock className="h-5 w-5 text-gray-400" />
                            </div>
                            <TextInput
                                id="password_confirmation"
                                type={showConfirmPassword ? "text" : "password"}
                                name="password_confirmation"
                                value={data.password_confirmation}
                                className="pl-10 pr-10 w-full"
                                autoComplete="new-password"
                                onChange={(e) => setData("password_confirmation", e.target.value)}
                                placeholder="Confirm your password"
                                required
                            />
                            <button
                                type="button"
                                className="absolute inset-y-0 right-0 pr-3 flex items-center"
                                onClick={() => setShowConfirmPassword(!showConfirmPassword)}
                            >
                                {showConfirmPassword ? (
                                    <EyeOff className="h-5 w-5 text-gray-400 hover:text-gray-600" />
                                ) : (
                                    <Eye className="h-5 w-5 text-gray-400 hover:text-gray-600" />
                                )}
                            </button>
                        </div>
                        <InputError message={errors.password_confirmation} className="mt-2" />
                    </div>

                    {/* Submit Button */}
                    <PrimaryButton 
                        className="w-full py-3 text-base font-medium" 
                        disabled={processing}
                    >
                        {processing ? "Creating account..." : "Create account"}
                    </PrimaryButton>

                    {/* Login Link */}
                    <div className="text-center">
                        <span className="text-sm text-gray-600 dark:text-gray-400">
                            Already have an account?{" "}
                        </span>
                        <Link
                            href={route("login")}
                            className="text-sm text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 font-medium underline transition-colors"
                        >
                            Sign in here
                        </Link>
                    </div>
                </form>

                {/* Trust Indicators */}
                <div className="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                    <div className="flex items-center justify-center space-x-6 text-xs text-gray-500 dark:text-gray-400">
                        <div className="flex items-center">
                            <Shield className="w-3 h-3 mr-1" />
                            <span>Secure</span>
                        </div>
                        <div className="flex items-center">
                            <Users className="w-3 h-3 mr-1" />
                            <span>Trusted</span>
                        </div>
                        <div className="flex items-center">
                            <Star className="w-3 h-3 mr-1" />
                            <span>Rated</span>
                        </div>
                    </div>
                </div>
            </div>
        </GuestLayout>
    );
}
