import { useForm } from "@inertiajs/react";
import PrimaryButton from "@/Components/PrimaryButton";
import InputLabel from "@/Components/InputLabel";
import TextInput from "@/Components/TextInput";
import { CreditCard, MapPin } from "lucide-react";

export default function BillingSettings({ user, countries, onSuccess }) {
    const { data, setData, post, processing } = useForm({
        billing_street_address: user?.billing_street_address || "",
        billing_city: user?.billing_city || "",
        billing_state_province: user?.billing_state_province || "",
        billing_postal_code: user?.billing_postal_code || "",
        billing_country_id: user?.billing_country_id || "",
        tax_id: user?.tax_id || "",
        company_name: user?.company_name || "",
    });

    const handleSubmit = (e) => {
        e.preventDefault();
        post(route("settings.billing.update"), {
            preserveScroll: true,
            onSuccess: () => {
                onSuccess("Billing address updated successfully.");
            },
        });
    };

    return (
        <form onSubmit={handleSubmit} className="space-y-6">
            <div className="flex items-center gap-2 mb-4">
                <MapPin className="h-5 w-5 text-gray-500 dark:text-gray-400" />
                <h3 className="text-lg font-semibold text-gray-900 dark:text-white">
                    Billing Address
                </h3>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <InputLabel htmlFor="company_name" value="Company Name (Optional)" />
                    <TextInput
                        id="company_name"
                        value={data.company_name}
                        onChange={(e) => setData("company_name", e.target.value)}
                        className="mt-1 block w-full"
                        placeholder="Enter company name"
                    />
                </div>

                <div>
                    <InputLabel htmlFor="tax_id" value="Tax ID / VAT Number (Optional)" />
                    <TextInput
                        id="tax_id"
                        value={data.tax_id}
                        onChange={(e) => setData("tax_id", e.target.value)}
                        className="mt-1 block w-full"
                        placeholder="Enter tax ID or VAT number"
                    />
                </div>

                <div className="md:col-span-2">
                    <InputLabel htmlFor="billing_street_address" value="Street Address" />
                    <TextInput
                        id="billing_street_address"
                        value={data.billing_street_address}
                        onChange={(e) => setData("billing_street_address", e.target.value)}
                        className="mt-1 block w-full"
                        placeholder="Enter street address"
                    />
                </div>

                <div>
                    <InputLabel htmlFor="billing_city" value="City" />
                    <TextInput
                        id="billing_city"
                        value={data.billing_city}
                        onChange={(e) => setData("billing_city", e.target.value)}
                        className="mt-1 block w-full"
                        placeholder="Enter city"
                    />
                </div>

                <div>
                    <InputLabel htmlFor="billing_state_province" value="State / Province" />
                    <TextInput
                        id="billing_state_province"
                        value={data.billing_state_province}
                        onChange={(e) => setData("billing_state_province", e.target.value)}
                        className="mt-1 block w-full"
                        placeholder="Enter state or province"
                    />
                </div>

                <div>
                    <InputLabel htmlFor="billing_postal_code" value="Postal / ZIP Code" />
                    <TextInput
                        id="billing_postal_code"
                        value={data.billing_postal_code}
                        onChange={(e) => setData("billing_postal_code", e.target.value)}
                        className="mt-1 block w-full"
                        placeholder="Enter postal code"
                    />
                </div>

                <div>
                    <InputLabel htmlFor="billing_country_id" value="Country" />
                    <select
                        id="billing_country_id"
                        value={data.billing_country_id}
                        onChange={(e) => setData("billing_country_id", e.target.value)}
                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    >
                        <option value="">Select a country</option>
                        {countries.map((country) => (
                            <option key={country.id} value={country.id}>
                                {country.name}
                            </option>
                        ))}
                    </select>
                </div>
            </div>

            <div className="flex justify-end">
                <PrimaryButton disabled={processing}>
                    {processing ? "Saving..." : "Save Billing Address"}
                </PrimaryButton>
            </div>
        </form>
    );
}







