import WriterLayout from "@/Layouts/WriterLayout";
import { Link, router, usePage } from "@inertiajs/react";
import {
    Trash2,
    Receipt,
    TimerIcon,
    Gavel,
    ArrowBigLeft,
    MessageCircleMore,
    TrendingUp,
    DollarSign,
} from "lucide-react";
import { useEffect, useState } from "react";

export default function ShowBid({ bid }) {
    console.log(bid);
    const { flash } = usePage().props;
    const [flashMsg, setFlashMsg] = useState(flash.message);

    useEffect(() => {
        if (flashMsg) {
            const timer = setTimeout(() => {
                setFlashMsg("");
            }, 3000);
            return () => clearTimeout(timer);
        }
    }, [flashMsg]);

    useEffect(() => {
        setFlashMsg(flash.message);
    }, [flash.message]);

    const getStatusBadgeClass = (status) => {
        switch (status) {
            case "pending":
                return "bg-yellow-300 text-yellow-800";
            case "accepted":
                return "bg-green-100 text-green-800";
            case "rejected":
                return "bg-red-100 text-red-800";
            default:
                return "bg-gray-100 text-gray-800";
        }
    };

    return (
        <WriterLayout>
            <div className="max-w-4xl mx-auto ">
                <div className="bg-gradient-to-b from-green-700 to-green-800 dark:bg-none dark:bg-gray-800 rounded-lg shadow-md overflow-hidden">
                    {/* Header */}
                    <div className="px-6 py-4 border-b dark:border-gray-700 flex justify-between items-center bg-gradient-to-r from-green-900 to-green-700 dark:bg-none text-gray-100  dark:bg-slate-700 rounded-t-lg">
                        <h1 className="text-xl font-bold text-gray-100 dark:text-white flex items-center">
                            <Gavel className="mr-2 h-6 w-6 text-gray-100" />{" "}
                            {/* {user.name} */}
                            Order {bid.order.order_number} Bid
                        </h1>
                    </div>
                    {flashMsg && (
                        <div className="bg-green-500 text-white text-sm px-4 py-2 rounded-md m-4">
                            {flashMsg}
                        </div>
                    )}

                    {/* Content */}
                    <div className="p-6 space-y-6">
                        <div className="grid grid-cols-1 sm:grid-cols-2 gap-6">
                            <div className="flex items-center gap-3">
                                <DollarSign className="h-5 w-5 text-blue-100" />
                                <div>
                                    <span className="text-sm text-gray-100 dark:text-gray-400">
                                        Bid Amount
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {bid.bid_amount}
                                    </p>
                                </div>
                            </div>
                            <div className="flex items-center gap-3">
                                <TimerIcon className="h-5 w-5 text-blue-100" />
                                <div>
                                    <span className="text-sm text-gray-100 dark:text-gray-400">
                                        Completion Time
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {bid.completion_time}
                                    </p>
                                </div>
                            </div>

                            <div className="flex items-center gap-3">
                                <TrendingUp className="h-5 w-5 text-blue-100" />
                                <div>
                                    <span className="text-sm text-gray-100 dark:text-gray-400">
                                        Bid Status
                                    </span>
                                    <p
                                        className={`text-lg font-medium ${
                                            bid.status === "pending"
                                                ? "text-yellow-800"
                                                : bid.status === "accepted"
                                                ? "text-green-500"
                                                : bid.status === "rejected"
                                                ? "text-red-500"
                                                : "text-gray-500"
                                        }`}
                                    >
                                        <p
                                            className={`inline-block px-3 py-1 mt-1 text-sm font-semibold rounded-full ${getStatusBadgeClass(
                                                bid.status
                                            )}`}
                                        >
                                            {bid.status
                                                .charAt(0)
                                                .toUpperCase() +
                                                bid.status.slice(1)}
                                        </p>
                                    </p>
                                </div>
                            </div>

                            <div className="flex items-center gap-3">
                                <MessageCircleMore className="h-5 w-5 text-blue-100" />
                                <div>
                                    <span className="text-sm text-gray-100 dark:text-gray-400">
                                        Comments
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {bid.comments ? bid.comments : "N/A"}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    {/* Actions */}

                    <div className="px-6 py-4 bg-gradient-to-b from-blue-200 to-cyan-300 dark:bg-none dark:bg-gray-700 flex flex-wrap gap-3 justify-end">
                        <div>
                            <Link
                                href="/writer/bids"
                                className="flex items-center gap-2 px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-md transition-colors"
                            >
                                <ArrowBigLeft className="h-5 w-5" />
                                Back
                            </Link>
                        </div>
                        {/* Delete Button */}
                        <div>
                            <button
                                onClick={() => {
                                    if (
                                        confirm(
                                            "Are you sure you want to delete this bid?"
                                        )
                                    ) {
                                        router.delete(
                                            route("writer.bids.destroy", bid.id)
                                        );
                                    }
                                }}
                                className="flex items-center gap-2 px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-md transition-colors"
                            >
                                <Trash2 className="h-5 w-5" />
                                Delete
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </WriterLayout>
    );
}
