import "../css/app.css";
import "./bootstrap";

import { createInertiaApp } from "@inertiajs/react";
import { resolvePageComponent } from "laravel-vite-plugin/inertia-helpers";
import { createRoot } from "react-dom/client";
import { Toaster } from "react-hot-toast";

const appName = import.meta.env.VITE_APP_NAME || "AcademicScribe";

createInertiaApp({
    // FIXED: Make the title template optional
    title: (title) => (title ? title : "AcademicScribe"),
    resolve: (name) =>
        resolvePageComponent(
            `./Pages/${name}.jsx`,
            import.meta.glob("./Pages/**/*.jsx")
        ),
    setup({ el, App, props }) {
        const root = createRoot(el);

        root.render(
            <>
                <App {...props} />
                <Toaster
                    position="top-right"
                    toastOptions={{
                        duration: 4000,
                        style: {
                            background: "#363636",
                            color: "#fff",
                            fontSize: "14px",
                            borderRadius: "8px",
                            padding: "12px 16px",
                        },
                        success: {
                            style: {
                                background: "#10B981",
                            },
                            iconTheme: {
                                primary: "#fff",
                                secondary: "#10B981",
                            },
                        },
                        error: {
                            style: {
                                background: "#EF4444",
                            },
                            iconTheme: {
                                primary: "#fff",
                                secondary: "#EF4444",
                            },
                        },
                    }}
                />
            </>
        );
    },
    progress: {
        color: "#0000FF",
        showSpinner: true,
    },
});
