<?php

namespace Tests\Unit;

use App\Services\NicknameGeneratorService;
use Tests\TestCase;

class NicknameGeneratorServiceTest extends TestCase
{
    /**
     * Test nickname generation with various name formats
     */
    public function test_nickname_generation()
    {
        // Test with a simple name
        $nickname1 = NicknameGeneratorService::generateNickname(123, 'John Doe');
        $this->assertEquals('johnd123', $nickname1);

        // Test with a name with special characters
        $nickname2 = NicknameGeneratorService::generateNickname(456, 'Mary-Jane O\'Connor');
        $this->assertEquals('maryj456', $nickname2);

        // Test with a very short name
        $nickname3 = NicknameGeneratorService::generateNickname(789, 'Li');
        $this->assertStringStartsWith('li', $nickname3);
        $this->assertStringEndsWith('789', $nickname3);

        // Test with a name containing numbers
        $nickname4 = NicknameGeneratorService::generateNickname(101, 'John123 Smith');
        $this->assertEquals('john1101', $nickname4);

        // Test with a very long name
        $nickname5 = NicknameGeneratorService::generateNickname(999, 'Supercalifragilisticexpialidocious');
        $this->assertEquals('super999', $nickname5);
    }

    /**
     * Test that nicknames are unique for different writers
     */
    public function test_nickname_uniqueness()
    {
        $nickname1 = NicknameGeneratorService::generateNickname(1, 'John Doe');
        $nickname2 = NicknameGeneratorService::generateNickname(2, 'John Doe');
        
        $this->assertNotEquals($nickname1, $nickname2);
        $this->assertEquals('johnd1', $nickname1);
        $this->assertEquals('johnd2', $nickname2);
    }

    /**
     * Test that nicknames are consistent for the same writer
     */
    public function test_nickname_consistency()
    {
        $nickname1 = NicknameGeneratorService::generateNickname(123, 'John Doe');
        $nickname2 = NicknameGeneratorService::generateNickname(123, 'John Doe');
        
        $this->assertEquals($nickname1, $nickname2);
    }
} 