-- SQL script to update ONLY the services section with color and features
-- This preserves all other homepage content blocks

UPDATE content_blocks 
SET content = JSON_SET(
    content,
    '$.services[0].color', 'blue',
    '$.services[0].features', JSON_ARRAY('All Academic Levels', '24/7 Support', 'Plagiarism-Free'),
    '$.services[1].color', 'green',
    '$.services[1].features', JSON_ARRAY('In-depth Research', 'Proper Citations', 'Quality Assurance'),
    '$.services[2].color', 'purple',
    '$.services[2].features', JSON_ARRAY('PhD Writers', 'Original Research', 'Timely Delivery'),
    '$.services[3].color', 'orange',
    '$.services[3].features', JSON_ARRAY('All Subjects', 'Custom Solutions', 'Fast Turnaround'),
    '$.services[4].color', 'indigo',
    '$.services[4].features', JSON_ARRAY('Detailed Analysis', 'Real Examples', 'Expert Insights'),
    '$.services[5].color', 'teal',
    '$.services[5].features', JSON_ARRAY('Systematic Review', 'Critical Analysis', 'Academic Standards'),
    '$.services[6].color', 'pink',
    '$.services[6].features', JSON_ARRAY('Research Proposals', 'Methodology Design', 'Literature Gap Analysis'),
    '$.services[7].color', 'red',
    '$.services[7].features', JSON_ARRAY('Python, Java, C++', 'Algorithm Design', 'Code Documentation')
)
WHERE block_type = 'services' 
AND block_key = 'services_section';

-- Verify the update
SELECT block_type, block_key, JSON_EXTRACT(content, '$.services[0].color') as first_service_color
FROM content_blocks 
WHERE block_type = 'services';
