import { defineConfig } from "vite";
import laravel from "laravel-vite-plugin";
import react from "@vitejs/plugin-react";

export default defineConfig({
    plugins: [
        laravel({
            input: "resources/js/app.jsx",
            refresh: true,
        }),
        react(),
    ],
    build: {
        // Enable code splitting and chunk optimization
        rollupOptions: {
            output: {
                manualChunks: {
                    // Separate vendor libraries into their own chunks
                    'react-vendor': ['react', 'react-dom'],
                    'inertia-vendor': ['@inertiajs/react'],
                    'motion-vendor': ['framer-motion'],
                    'icons-vendor': ['lucide-react'],
                    'editor-vendor': ['@tiptap/react', '@tiptap/starter-kit'],
                },
                // Optimize chunk size
                chunkFileNames: 'assets/[name]-[hash].js',
                entryFileNames: 'assets/[name]-[hash].js',
                assetFileNames: 'assets/[name]-[hash][extname]',
            },
        },
        // Increase chunk size warning limit (we'll handle it with splitting)
        chunkSizeWarningLimit: 600,
        // Enable minification with esbuild (faster than terser)
        minify: 'esbuild',
        // Enable CSS code splitting
        cssCodeSplit: true,
        // Source maps for production debugging (optional, disable for smaller builds)
        sourcemap: false,
    },
    // Optimize dependencies
    optimizeDeps: {
        include: [
            'react',
            'react-dom',
            '@inertiajs/react',
            'framer-motion',
            'lucide-react',
            '@tiptap/react',
            '@tiptap/starter-kit',
        ],
    },
});
